#######################################################################
# R code: Exercise 12.3
# File: dp.r
# Coded by: Marcin Wolski
#
# Calculates the Diks-Panchenko (DP, 2006) p-values of the modified 
# bivariate nonparametric causality test statistic
#
# Reference:
# Diks, C. and Panchenko, V. (2006).
#    A new statistic and practical guidelines for nonparametric Granger 
#    causality testing.
#    Journal of Economic Dynamics & Control, 30(9-10), 1647-1669.
#    DOI: 10.1016/j.jedc.2005.08.008.
#######################################################################
dp = function(x, y, lag=1, lagmax=1, epsilon=1.5) {
N    = length(x)
IYij = IXYij = IYZij = IXYZij = 0
disx = disy = disz = 0
h    = Cy = Cxy = Cyz = Cxyz = rep(0,N)
T2   = 0
n    = N-lagmax

# Calculating correlation integrals
i = lagmax+1
while(i<(N+1)) {
        Cy[i] = Cxy[i] = Cyz[i] = Cxyz[i] = 0
        j = lagmax+1
        while(j<(N+1)) {
                if(j!=i) {
                        disx = disy = 0
                        for(s in 1:lag) {
                                disx = max(abs(x[i-s]-x[j-s]),disx)
                        }
                        for(s in 1:lagmax) {
                                disy = max(abs(y[i-s]-y[j-s]),disy)
                        }                
                        if(disy<=epsilon) {
                        Cy[i] = Cy[i]+1
                                if(disx<=epsilon) {
                                        Cxy[i] = Cxy[i]+1
                                }
                                disz = max(abs(y[i]-y[j]),disy)
                                if(disz<=epsilon) {
                                        Cyz[i] = Cyz[i]+1
                                                if(disx<=epsilon) {
                                                     Cxyz[i] = Cxyz[i]+1
                                                }
                                }
                        }
                }
        j = j+1
        }
        
        Cy[i]   = Cy[i]/n
        Cxy[i]  = Cxy[i]/n
        Cyz[i]  = Cyz[i]/n
        Cxyz[i] = Cxyz[i]/n
        h[i] = h[i]+2*(Cxyz[i]*Cy[i]-Cxy[i]*Cyz[i])/6 #to check!  
        j = lagmax+1
        while(j<(N+1)) {
                if(j!=i) {
                   IYij = IXYij = IYZij = IXYZij = 0
                   disx = disy = 0
                        for(s in 1:(lag)) {
                           disx = max(abs(x[i-s]-x[j-s]),disx)
                        }
                        for(s in 1:(lagmax)) {
                           disy = max(abs(y[i-s]-y[j-s]),disy)
                        }
                        if(disy<=epsilon) {
                        IYij = 1
                            if(disx<=epsilon) {
                                     IXYij = 1
                                }
                                disz = max(abs(y[i]-y[j]),disy)
                                if(disz<=epsilon) {
                                        IYZij = 1
                                                if(disx<=epsilon) {
                                                    IXYZij = 1
                                                }
                                }
                        }
        h[j]=h[j]+2*(Cy[i]*IXYZij-Cyz[i]*IXYij)/
                 (6*n)+2*(Cxyz[i]*IYij-Cxy[i]*IYZij)/(6*n)
                }
        j = j+1
        }        
        T2 = T2+Cxyz[i]*Cy[i]-Cyz[i]*Cxy[i]       
i = +1
}
T2 = T2/n
i  = lagmax+1
while(i<(N+1)){
    h[i] = h[i]-T2
i = i+1
}
# End of calculating correlation integrals

K      = floor(sqrt(sqrt(N)))
ohm    = rep(0,K)
ohm[1] = 1
for(k in 2:(K+1)) {
       ohm[k] = 2*(1-(k-1)/K)
}

# Autocovariance of h
cov = rep(0,K)
for(k in 1:K) {
        for(i in (lagmax+k):N) {
           cov[k] = cov[k]+h[i]*h[i-k+1]     
        }       
        cov[k] = cov[k]/(n-(k-1))
}

VT2 = 0
for(k in 1:K) {
      VT2 = VT2+9*ohm[k]*cov[k]
}

T2_TVAL = T2*sqrt(n)/sqrt(VT2)

# Calculating p-values
p_T2 = pnorm(-T2_TVAL)
return(p_T2)
}
